<?php 
 ob_start();
    header('Content-Type: text/html; charset=UTF-8');
    //require("fpdf/fpdf.php");
    require("fpdf/pdf_js.php");
    require_once("PDF417/vendor/autoload.php");
    use BigFish\PDF417\PDF417;
    use BigFish\PDF417\Renderers\ImageRenderer;
    include ("letras/NumeroALetras.php");
    include ("config.php");

    /******************************************************************************************/
    /* Funciones 
    /******************************************************************************************/
    function floattostr( $val )
    {
        preg_match( "#^([\+\-]|)([0-9]*)(\.([0-9]*?)|)(0*)$#", trim($val), $o );
        return $o[1].sprintf('%d',$o[2]).($o[3]!='.'?$o[3]:'');
    }

    /******************************************************************************************/
    /* consultas SQL
    /******************************************************************************************/
    

    $id = $_GET['id_venta'];
    $mysqli = new mysqli($db_host,$db_user,$db_pass,$db_name);

    //Para obtener los datos de la venta
    $query1 = "SELECT v.*, v.created_at as hora,  u.username,  c.*, l.direccion as direc, l.telefono as telef FROM ventas v INNER JOIN clientes c ON v.id_cliente = c.id_cliente INNER JOIN local l ON v.id_local = l.id_local INNER JOIN usuarios u ON v.id_usuario = u.id_usuario WHERE id_venta = '".$id."' ";
    $result1 = $mysqli->query($query1);
    $row1 = $result1->fetch_assoc();

    //Para obtener los detalles de la venta
    $query2 = "SELECT * FROM detalle_venta d INNER JOIN productos p ON d.id_producto = p.id_producto WHERE id_venta = '".$id."' ";
    $result2 = $mysqli->query($query2);

    //Para obtener los datos de la empresa
    $query3 = "SELECT * FROM empresa WHERE id_empresa = '1' ";
    $result3 = $mysqli->query($query3);
    $row3 = $result3->fetch_assoc();

    //Para obtener los datos del tipo de comprobante
    $query4 = "SELECT t.* FROM ventas v INNER JOIN tipo_comprobante t ON v.id_tipo_comprobante = t.id_tipo_comprobante WHERE id_venta = '".$id."' ";
    $result4 = $mysqli->query($query4);
    $row4 = $result4->fetch_assoc();



    // Variables correspondientes a la factura.
    $RUC        = $row1['numero_documento'];    // RUC.
    $NomRazSoc  = $row1['nombre'];              // Nombre o Razón social.
    $FecEmi     = $row1['fecha_venta'];         // Fecha de emisión.
    $Domicilio  = $row1['direccion'];           // Domicilio de cliente.
    $CodHash    = "";                           // Código Hash.
    $TipoDoc    = $row1['id_tipo_comprobante']; // Tipo de documento.
    $TotGrav    = 0;                            // Total gravado.
    $TotIGV     = 0;                            // Total IGV.
    $TotMonto   = 0;                            // Total importe. 
    $autoriza   = $row3['autorizacion'];
    $pagina     = $row3['pagina_web'];
    $empresa    = $row3['razon_social'];

    $xml = @file_get_contents('../sunat/xml/comprobantes/'.$row3['ruc'].'-'.$row4['codigo'].'-'.$row1['nombre_comprobante'].'.xml');

    if ($xml) {
        // Obteniendo datos del archivo .XML 
        $DOM = new DOMDocument('1.0', 'ISO-8859-1');
        $DOM->preserveWhiteSpace = FALSE;
        $DOM->loadXML($xml);

       // Obteniendo Codigo Hash
        $DocXML = $DOM->getElementsByTagName('DigestValue');
        $i=0;
        foreach($DocXML as $Nodo){
            if ($i==0){
                $CodHash = $Nodo->nodeValue; 
            }
            $i++;
        }
    }     
   
    // TOTALES DE LA FACTURA 
    
    $sub_total_afe = 0;
    $sub_total_exo = 0;
    $sub_total_ina = 0;
    $total = 0;
    $igv = 0;
    $desc = 0;
    $ii=0;
    $total_icbper = 0;
    $tiene_icbper = 0;

    while($row2 = $result2->fetch_assoc()){

        
        $array['detalle'][$ii]['descripcion'] = $row2['nombre']." ".$row2['descripcion']; 
        $array['detalle'][$ii]['cantidad'] = number_format($row2['cantidad'] , 4, ".", ""); 
        $array['detalle'][$ii]['precio_unitario'] = number_format($row2['precio_venta'], 4, ".", ""); 
        $array['detalle'][$ii]['subtotal'] = number_format($row2['precio_venta_total'] , 2, ".", ""); 
        $array['detalle'][$ii]['descuento'] = number_format($row2['descuento'] , 2, ".", ""); 


        if ( $row2['situacion_impuesto'] == "AFECTO") {
            $sub_total_afe = $sub_total_afe + $row2['precio_venta_neto'];
            $igv = $igv + $row2['impuesto'];
        }
        else if ( $row2['situacion_impuesto'] == "EXONERADO") {
            $sub_total_exo = $sub_total_exo + $row2['precio_venta_neto'];
        }
        else if ( $row2['situacion_impuesto'] == "INAFECTO") {
            $sub_total_ina = $sub_total_ina + $row2['precio_venta_neto'];
        }

        if ($row2['icbper'] == 1 ) {
            $total_icbper = $total_icbper + $row3['valor_icbper'] * $row2['cantidad'] ;
            $tiene_icbper = 1;
        }


        $ii++;
    }

    $TotGrav = number_format($sub_total_afe+$sub_total_exo+$sub_total_ina, 2, '.', '');
    $TotIGV = number_format($igv, 2, '.', '');
    $TotICBPER = number_format($total_icbper , 2, '.', '');
    $TotMonto = number_format($row1['total_venta'], 2, '.', '');       


    // Crear el gráfico con el código de barras
    $nom_f = $row1['nombre_comprobante'];
    $tip_f = $row4['nombre'];
    $ruc_e = $row3['ruc'];
    $textoCodBar = "
        | RUC : $ruc_e
        | $tip_f ELECTRONICA
        | $nom_f
        | SUBTOTAL : $TotGrav
        | IGV : $TotIGV
        | IGV : $TotICBPER
        | TOTAL : $TotMonto
        | $FecEmi
        | $CodHash
        ";

    $pdf417 = new PDF417();
    $codigo_barra = $pdf417->encode($textoCodBar);
    // Create a PNG image
    $renderer = new ImageRenderer( ['format' => 'png'] );
    $image = $renderer->render($codigo_barra);
    $image->save('image/image_hash.png');
 


    /******************************************************************************************/
    /* creamos documento PDF
    /******************************************************************************************/
    
    $pdf = new PDF('P','cm', array(8,500));

    //$pdf=new PDF('P','cm','Letter');
    $pdf->AliasNbPages();
    $pdf->AddPage();
    $pdf->AddFont('IDAutomationHC39M','','IDAutomationHC39M.php');
    $pdf->AddFont('helvetica','','helvetica.php');
    $pdf->SetAutoPageBreak(true);
    $pdf->SetMargins(0, 0, 0);
    $pdf->SetLineWidth(0.02);
    $pdf->SetFillColor(0,0,0);

    //DATOS DE EMPRESA
    if($row1['id_local']==1){
        $pdf->image("../public/img/logo_empresa.jpg",1.6, 0.2 , 4.2, 1.5); // x , y, ancho, alto
    } else {
        $pdf->image("../public/img/logo_empresa2.jpg",1.6, 0.2 , 4.2, 1.5); // x , y, ancho, alto
    } 

    $pdf->SetFont('helvetica','B',8);
    $h_empresa = $pdf->GetMultiCellHeight(7, 0.31, utf8_decode($empresa) , $border=null, $align='L'); 
    $pdf->SetXY(0, 1.8);
    $pdf->MultiCell(7.6, 0.3, $empresa, 0, "C", 0);


    $pdf->SetFont('helvetica','',7);
    $pdf->SetXY(0,1.85 + $h_empresa);
    $pdf->Cell(7.6, 0.25, "RUC: ".$row3['ruc']."   Telf: ".$row1['telef']."", 0, 1,'C', 0);

    
    $pdf->SetXY(0, 2.15 + $h_empresa);
    $pdf->MultiCell(7.6, 0.25, $row1['direc'], 0, 'C', 0);
    $h_direcc = $pdf->GetMultiCellHeight(7, 0.31, utf8_decode($row1['direc']) , $border=null, $align='L'); 

    $pdf->SetFont('helvetica','B',9.5);
    $pdf->SetXY(0,2.55 + $h_empresa + $h_direcc );
    $pdf->Cell(7.6, 0.25, utf8_decode($row4['nombre']." ".($row4['nombre'] == "BOLETA" ? " DE VENTA ": "")." ELECTRÓNICA"), 0, 1,'C', 0);

    $pdf->SetXY(0,2.95 + $h_empresa + $h_direcc );
    $pdf->Cell(7.6, 0.25, utf8_decode($row1['nombre_comprobante']), 0, 1,'C', 0);

    //DATOS DE FACTURA
    
    $pdf->SetFont('helvetica','B',7);
    $h_titu = $pdf->GetMultiCellHeight(5.1, 0.31, utf8_decode($NomRazSoc) , $border=null, $align='L'); 
    $h_domi = $pdf->GetMultiCellHeight(5.1, 0.31, utf8_decode($Domicilio) , $border=null, $align='L'); 

    $pdf->SetXY(0.2,3.2+$h_empresa + $h_direcc );
    $pdf->Cell(1, 0.35, utf8_decode("================================================="), 0, 1,'L', 0);


    if ($row4['nombre'] == "FACTURA") {
        $pdf->SetXY(0.2,3.6+$h_empresa + $h_direcc );
        $pdf->Cell(1, 0.35, utf8_decode("Razon Social     : "), 0, 1,'L', 0);

        $pdf->SetXY(0.2,3.6+$h_titu+$h_domi+$h_empresa + $h_direcc );
        $pdf->Cell(1, 0.35, utf8_decode("RUC"), 0, 1,'L', 0);
    }
    else {
        $pdf->SetXY(0.2,3.6+$h_empresa + $h_direcc );
        $pdf->Cell(1, 0.35, utf8_decode("Señor(es)           : "), 0, 1,'L', 0);

        $pdf->SetXY(0.2,3.6+$h_titu+$h_domi+$h_empresa + $h_direcc );
        $pdf->Cell(1, 0.35, utf8_decode("DNI"), 0, 1,'L', 0);
    }


    $pdf->SetXY(0.22,3.6+$h_titu+$h_empresa + $h_direcc );
    $pdf->Cell(1, 0.35, utf8_decode("Domicilio           : "), 0, 1,'L', 0);

    $pdf->SetXY(0.2,3.95+$h_titu+$h_domi+$h_empresa + $h_direcc );
    $pdf->Cell(1, 0.35, utf8_decode("Fecha Emision"), 0, 1,'L', 0);

    $pdf->SetXY(0.2,4.31+$h_titu+$h_domi+$h_empresa + $h_direcc );
    $pdf->Cell(1, 0.35, utf8_decode("Tipo Moneda"), 0, 1,'L', 0);


    $pdf->SetFont('helvetica','',7);

    $pdf->SetXY(2.4,3.6+$h_empresa + $h_direcc );
    $pdf->MultiCell(5.1, 0.3, $NomRazSoc , 0, "L", 0);

    $pdf->SetXY(2.4,3.6+$h_titu+$h_empresa + $h_direcc );
    $pdf->MultiCell(5.1, 0.3, $Domicilio , 0, "L", 0);

    $pdf->SetXY(2.1,3.6+$h_titu+$h_domi+$h_empresa + $h_direcc );
    $pdf->Cell(1, 0.35, ":   ".utf8_decode($RUC), 0, 1,'L', 0);

    $pdf->SetXY(2.1,3.95+$h_titu+$h_domi+$h_empresa + $h_direcc );
    $pdf->Cell(1, 0.35, ":   ".date_format(date_create($FecEmi), 'd-m-Y')."        Hora : ".date("H:i:s", strtotime($row1['hora'])), 0, 1,'L', 0);


    //TIPO PAGO
    if ($row1["tipo_pago"] == "EFECTIVO" || $row1["tipo_pago"] == "TARJETA" || $row1["tipo_pago"] == "LIQUIDACION") {
        $tipo_pago = "CONTADO";
    } else { 
        $tipo_pago = "CREDITO"; 
        $pdf->SetXY(4,3.6+$h_titu+$h_domi+$h_empresa + $h_direcc );
        $pdf->Cell(1, 0.35, "  F. Vencimiento : ".$row1['fecha_pago'], 0, 1,'L', 0);
    }
    $pdf->SetXY(2.1,4.31+$h_titu+$h_domi+$h_empresa + $h_direcc );
    $pdf->Cell(1, 0.35, ":   ".utf8_decode("SOL")."                   Tipo Pago : ". $tipo_pago, 0, 1,'L', 0);




    //DATOS DETALLE FACTURA

    $pdf->SetTextColor(0,0,0);
    $pdf->SetFont('helvetica','B',7);
    
    $pdf->SetXY(0.2,4.6+$h_titu+$h_domi+$h_empresa+ $h_direcc );
    $pdf->Cell(1, 0.35, utf8_decode("================================================="), 0, 1,'L', 0);

    $Y = $h_titu+$h_domi+$h_empresa + $h_direcc ;

    $pdf->SetXY(0.2,$Y+4.8);
    $pdf->Cell(0.8, 0.5, utf8_decode("Cant."), 0, 1,'C', 0);

    $pdf->SetXY(1.0,$Y+4.8);
    $pdf->Cell(3, 0.5, utf8_decode("Descripción"), 0, 1,'C', 0);

    $pdf->SetXY(4,$Y+4.8);
    $pdf->Cell(1.2, 0.5, utf8_decode("Precio"), 0, 1,'R', 0);

    $pdf->SetXY(5,$Y+4.8);
    $pdf->Cell(1.2, 0.5, utf8_decode("Dscto"), 0, 1,'R', 0);

    $pdf->SetXY(6.2,$Y+4.8);
    $pdf->Cell(1.2, 0.5, utf8_decode("Importe"), 0, 1,'R', 0);

    $pdf->SetXY(0.2,$Y+5.15);
    $pdf->Cell(1, 0.35, utf8_decode("================================================="), 0, 1,'L', 0);

  
    $pdf->SetFont('helvetica','',7);
    $Y=$Y+5.6;
    $Y1 = 0;

    for ($i=0; $i < sizeof($array['detalle']) ; $i++) { 

        $h_descrip = $pdf->GetMultiCellHeight(3, 0.35, utf8_decode($array['detalle'][$i]['descripcion']), $border=null, $align='L'); 

        $pdf->SetXY(0.2,$Y+$Y1);
        $pdf->Cell(0.8, 0.35, floattostr($array['detalle'][$i]['cantidad']), 0, 1,'C', 0);

        $pdf->SetXY(1.0,$Y+$Y1);
        $pdf->MultiCell(3, 0.35, $array['detalle'][$i]['descripcion'] , 0, "L", 0);

        $pdf->SetXY(3.9,$Y+$Y1);
        $pdf->Cell(1.2, 0.35, floattostr($array['detalle'][$i]['precio_unitario']), 0, 1,'R', 0);

        $pdf->SetXY(5.3,$Y+$Y1);
        $pdf->Cell(0.8, 0.35, ($array['detalle'][$i]['descuento']==0 ? $array['detalle'][$i]['descuento'] : '-'.$array['detalle'][$i]['descuento'] ), 0, 1,'R', 0);

        $pdf->SetXY(6,$Y+$Y1);
        $pdf->Cell(1.4, 0.35, $array['detalle'][$i]['subtotal'], 0, 1,'R', 0);

        $Y1 = $Y1 + $h_descrip;
    } 

    //TOTALES FACTURA
    $pdf->SetFont('helvetica','',7);

   // $Y2 = $Y1 + $h_titu + $h_domi + $h_empresa + $h_direcc + 5.6;

    //if ($row1['id_tipo_comprobante'] == 1) { //OCULTA IGV PARA BOLETAS

        $Y2 = $Y1 + $h_titu + $h_domi + $h_empresa  + $h_direcc  + 4.6;

        $pdf->line(0.25, $Y2+1.5, 7.35, $Y2+1.5);


        if ($sub_total_afe != 0) {
            $pdf->SetXY(0.2, $Y2+1.7);
            $pdf->Cell(6, 0.35, utf8_decode("Valor de Venta - Operaciones Gravadas          S/ "), 0, 1,'R', 0);

            $pdf->SetXY(6.2, $Y2+1.7);
            $pdf->Cell(1.2, 0.35, number_format($sub_total_afe,2), 0, 1,'R', 0);

            $Y2 = $Y2 + 0.4;
        }

        if ($sub_total_exo != 0)  {
            $pdf->SetXY(0.2, $Y2+1.7);
            $pdf->Cell(6, 0.35, utf8_decode("Operaciones Exoneradas          S/ "), 0, 1,'R', 0);

            $pdf->SetXY(6.2, $Y2+1.7);
            $pdf->Cell(1.2, 0.35, number_format($sub_total_exo,2), 0, 1,'R', 0);

            $Y2 = $Y2 + 0.4;
        }

        if ($sub_total_ina != 0) {
            $pdf->SetXY(0.2, $Y2+1.7);
            $pdf->Cell(6, 0.35, utf8_decode("Operaciones Inafectas          S/ "), 0, 1,'R', 0);

            $pdf->SetXY(6.2, $Y2+1.7);
            $pdf->Cell(1.2, 0.35, number_format($sub_total_ina,2), 0, 1,'R', 0);

            $Y2 = $Y2 + 0.4;
        }
        

        $pdf->SetXY(0.2, $Y2+1.7);
        $pdf->Cell(6, 0.35, utf8_decode("IGV          S/ "), 0, 1,'R', 0);

        $pdf->SetXY(6.2, $Y2+1.7);
        $pdf->Cell(1.2, 0.35, number_format($TotIGV,2), 0, 1,'R', 0);

        // TIENE ICBPER
        if ($tiene_icbper == 1) {

            $Y2 = $Y2 + 0.4;

            $pdf->SetXY(0.2, $Y2+1.7);
            $pdf->Cell(6, 0.35, utf8_decode("ICBPER         S/ "), 0, 1,'R', 0);

            $pdf->SetXY(6.2, $Y2+1.7);
            $pdf->Cell(1.2, 0.35, number_format($TotICBPER,2), 0, 1,'R', 0);

        }

        $Y2 = $Y2 + 2;
   // }

    

/*    if ($tiene_icbper == 1) {

        if ($row1['id_tipo_comprobante'] == 2) {
            $Y2 = $Y2 + 0.2;
            $pdf->line(0.25, $Y2, 7.35, $Y2);
        }

        $pdf->SetXY(0.2,$Y2+0.1);
        $pdf->Cell(6, 0.35, utf8_decode("ICBPER         S/ "), 0, 1,'R', 0);

        $pdf->SetXY(6.2,$Y2+0.1);
        $pdf->Cell(1.2, 0.35, number_format($TotICBPER,2), 0, 1,'R', 0);
        $Y2 = $Y2 + 0.4;

    }*/

    $pdf->line(0.25, $Y2+0.2, 7.35, $Y2+0.2);

    $pdf->SetFont('helvetica','B',9);
    $pdf->SetXY(0.2,$Y2+0.4);
    $pdf->Cell(5.8, 0.35, utf8_decode("Importe Total         "), 0, 1,'R', 0);


    $pdf->SetFont('helvetica','B',9);

    $pdf->SetXY(6.2,$Y2+0.4);
    $pdf->Cell(1.2, 0.35, "S/ ".number_format($TotMonto,2), 0, 1,'R', 0);

   


    //Monto en LETRAS
    $letras = NumeroALetras::convertir($TotMonto, 'soles', 'centimos');
    $pdf->SetFont('helvetica','BI',6.5);
    $pdf->SetXY(0.15, $Y2+1.2);
    $pdf->MultiCell(7, 0.3,"SON : ".$letras ."  SOLES" , 0, 'L');

    $h_letras = $pdf->GetMultiCellHeight(7, 0.35, $letras, $border=null, $align='L'); 

    //Observacion
    $h_obser = 0;

    if (!is_null($row1['observacion'])) {
        $h_obser = $pdf->GetMultiCellHeight(7, 0.35, utf8_decode($row1['observacion']), $border=null, $align='L'); 
        $pdf->SetFont('helvetica','I',6.5);
        $pdf->SetXY(0.15,$Y2+$h_letras+1.4);
        $pdf->MultiCell(7, 0.35,"OBSERVACION : ".$row1['observacion'] , 0, 'L');
    }

    // nombre de usuario
    $pdf->SetFont('helvetica','BI',6.5);
    $pdf->SetXY(0.15,$Y2+2+$h_letras+$h_obser );
    $pdf->MultiCell(5, 0.4,"USUARIO : ".$row1['username'] , 0, 'L');

    //CODIGO HASH
    $pdf->image('image/image_hash.png',0.8, $Y2+2.4+$h_letras+$h_obser , 6, 2);  // x , y, ancho, alto

    if ($row3['modulo_puntos'] != 0 && $row1['id_cliente'] != 1) {
        $puntos = intdiv($row1['total_venta'], 10);
        //PIE DE PAGINA
        $pdf->SetFont('helvetica','',7);
        $pdf->SetXY(0,$Y2+4.4+$h_letras+$h_obser );
        $pdf->MultiCell(7.5, 0.35, utf8_decode("Representación Impresa del Comprobante Electrónico \n\n Código Hash: $CodHash
        Autorizado para ser Emisor Electrónico por la $autoriza \n $pagina \n\n CON ESTA COMPRA USTED ACUMULÓ $puntos PUNTO(S) \n GRACIAS POR SU PREFERENCIA !!"), 0, 'C');
    } 

    else{
        //PIE DE PAGINA
        $pdf->SetFont('helvetica','',7);
        $pdf->SetXY(0,$Y2+4.4+$h_letras+$h_obser );
        $pdf->MultiCell(7.5, 0.35, utf8_decode("Representación Impresa del Comprobante Electrónico \n\n Código Hash: $CodHash
        Autorizado para ser Emisor Electrónico por la $autoriza \n $pagina \n GRACIAS POR SU PREFERENCIA !!"), 0, 'C');
    }



    //==============================================================================

    $pdf->AutoPrint(true);
    $pdf->Output();

    unlink('image/image_hash.png');
ob_end_flush(); 