@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">REGISTRAR NUEVO EGRESO</h4>
            <br>

            <form class="ui form" id="frmNuevo" autocomplete="off">

                    <div class="three fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Sucursal</div>
                        </div>
                        <div class="nine wide field">
                            <select class="ui fluid small input dropdown" name="id_local">
                                 <option value="{{ $local->id_local }}"> {{ $local->nombre }} ({{ ucwords(mb_strtolower($local->direccion ))}})</option>
                            </select>  
                        </div>
                    </div>
                    
                    <div class="three fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Tipo de Egreso</div>
                        </div>
                        <div class="nine wide field">
                            <select class="ui small input dropdown" name="tipo_egreso">
                                <option value="">Seleccione...</option>
                                <option value="FIJO">Fijo</option>
                                <option value="VARIABLE">Variable</option>
                            </select> 
                        </div>
                    </div>

                    <div class="three fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Concepto</div>
                        </div>
                        <div class="nine wide field">
                            <select class="ui small input dropdown" name="concepto">
                                <option value="">Seleccione...</option>
                                <option value="OBLIGACIONES">Obligaciones</option>
                                <option value="SERVICIOS">Servicios</option>
                                <option value="SUELDOS">Sueldos</option>
                                <option value="IMPREVISTOS">Imprevistos</option>
                                <option value="OTROS">Otros</option>
                            </select> 
                        </div>
                    </div>

                    <div class="three fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Descripcion del egreso</div>
                        </div>
                        <div class="nine wide field">
                            <div class="ui small input ">
                              <input type="text" name="descripcion"  maxlength="200" oninput="$.upperCase(this)">
                            </div>
                        </div>
                    </div>

                    <div class="three fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Tipo Comprobante</div>
                        </div>
                        <div class="nine wide field">
                            <select class="ui small input dropdown" name="tipo_comprobante">
                                <option value="">Seleccione</option>
                                <option value="Factura">Factura</option>
                                <option value="Boleta">Boleta</option>
                                <option value="Recibo">Recibo</option>
                                <option value="Otros">Otros</option>
                            </select> 
                        </div>
                    </div>
                    
                    <div class="four fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Numero de comprobante</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui small input ">
                                <input type="text" name="numero_comprobante" maxlength="20" oninput="$.upperCase(this)">
                            </div>
                        </div>
                    </div>

                    <div class="four fields">
                        <div class="four wide field">
                            <div class="ui fluid large white label">Monto del egreso</div>
                        </div>
                        <div class="three wide field">
                            <div class="ui labeled small input">
                                <label class="ui label">S/</label>
                                <input type="text" name="monto" maxlength="11">
                            </div> 
                        </div>
                    </div>

                    <div class="form_footer">
                        <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>REGISTRAR</div>
                    </div>

            </form>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="check circle icon"></i>Registrar Información</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea registrar esta información en el sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para registrar"> <i class="checkmark icon"></i>Registrar</div>
        </div>
    </div>
    <!--end register modal -->
    

    
@stop

@section('scripts')
    <script src="{{ asset('js/egreso/nuevo.js') }}"></script>
@stop


